install.packages("purrr")
library(ggplot2)
library(purrr)

Activity <- c("A1", "A2", "A3", "A4", "A5")
alpha <- c(2.64, 2.60, 3.07, 2.56, 2.56)
beta <- c(0.17, 0.18, 0.08, 0.20, 0.20)

# Función para generar muestras de la distribución Beta
generate_beta_samples <- function(alpha, beta, n) {
  rbeta(n, alpha, beta)
}

# Generar muestras para cada modelo Beta
num_samples <- 1000
beta_samples <- map2(alpha, beta, generate_beta_samples, n = num_samples)

# Crear un data frame con los datos de las muestras
data <- data.frame(Activity = rep(Activity, each = num_samples),
                   Probability = unlist(beta_samples))

# Graficar los modelos de probabilidad usando un gráfico de densidad
ggplot(data, aes(x = Probability, fill = Activity)) +
  geom_density(alpha = 0.5) +
  labs(x = "Probability", y = "Density", title = "Probability Models") +
  theme_minimal() +
  ylim(0, 6) +
  xlim(0.75, 1)

# otra forma de hacer el gráfico
ggplot(data, aes(x=Probability, group=Activity, fill=Activity,color=Activity))+
  geom_density(adjust=1.5, alpha=.2, fill="NA", lwd=0.8) + xlim(0.9,1) + ylim(0,100) + scale_color_manual(values=c("Red", "Orange", "Blue","Green","Dark Green" ))+theme_minimal() 
theme_ipsum()


########################################3
# obteniendo el modelo multinomial
library(ggplot2)
library(plyr)

Median1 <- c(0.997,0.994,1,0.991,0.989)
IQR1 <- c(0.0488,0.0625,0.00596,0.0716,0.0868)

# Create a data frame with median and IQR values
frequency_data <- data.frame(Activity, Median1, IQR1)

# Set the color scale
color_scale <- scale_fill_gradient(name = "Scale", low = "lightblue", high = "darkblue")

# Plot the multinomial model with colored bars and error bars
ggplot(frequency_data, aes(x = Activity, y = Median1, fill = Median1)) +
  geom_bar(stat = "identity") +
  geom_errorbar(aes(ymin = Median1 - IQR1, ymax = Median1 + IQR1), width = 0.2, position = position_dodge(0.9)) +
  labs(x = "Activity", y = "Probability of importance level") +
  theme_minimal() +
  color_scale +
  guides(fill = guide_colorbar(title = ""))


########################################
######################################## Considerando áreas
library(ggplot2)
library(plyr)

# Datos del grupo 1
Median1 <- c(0.998, 1, 1, 1, 0.995)
IQR1 <- c(0.0399, 0.00614, 0.0918, 0.00682, 0.0653)
group1 <- rep("<18.77", length(Median1))

# Datos del grupo 2
Median2 <- c(0.902, 0.987, 1, 0.998, 0.89)
IQR2 <- c(0.249, 0.098, 0.0059, 0.0359, 0.258)
group2 <- rep(">=18.77 & <=53.74", length(Median2))

# Datos del grupo 3
Median3 <- c(1, 0.929, 1, 1, 1)
IQR3 <- c(0.0048, 0.219, 0.00767, 0.00364, 0.00475)
group3 <- rep(">53.74", length(Median3))

# Combinar todos los datos en un data frame
frequency_data <- data.frame(Activity = rep(c("A1", "A2", "A3", "A4", "A5"), 3),
                             Median = c(Median1, Median2, Median3),
                             IQR = c(IQR1, IQR2, IQR3),
                             Group = c(group1, group2, group3))

# Set the color scale
color_scale <- scale_fill_gradient(low = "lightblue", high = "darkblue")

# Plot the multinomial model with colored bars and error bars
ggplot(frequency_data, aes(x = Activity, y = Median, fill = Median)) +
  geom_bar(stat = "identity", position = "dodge") +
  geom_errorbar(aes(ymin = Median - IQR, ymax = Median + IQR),
                width = 0.2, position = position_dodge(0.9)) +
  labs(x = "Activity", y = "Probability of importance level") +
  theme_minimal() +
  color_scale +
  facet_grid(. ~ Group, scales = "free") +
#  guides(fill = guide_colorbar(title = "Median"))
  guides(fill = guide_colorbar(title = ""))




########################################
######################################## Considerando Experticia
# Datos del grupo 1
Median1 <- c(0.989,0.974,1,0.977,0.988)
IQR1 <- c(0.0863,0.13,0.00792,0.131,0.0806)
group1 <- rep("<7", length(Median1))

# Datos del grupo 2
Median2 <- c(1,0.984,1,1,1)
IQR2 <- c(0.00383,0.0982,0.00668,0.00428,0.00319)
group2 <- rep(">=7 & <=20", length(Median2))

# Datos del grupo 3
Median3 <- c(0.991,1,1,0.991,0.968)
IQR3 <- c(0.0794,0.00616,0.00656,0.0783,0.155)
group3 <- rep(">20", length(Median3))
  
# Combinar todos los datos en un data frame
frequency_data <- data.frame(Activity = rep(c("A1", "A2", "A3", "A4", "A5"), 3),
                             Median = c(Median1, Median2, Median3),
                             IQR = c(IQR1, IQR2, IQR3),
                             Group = c(group1, group2, group3))

# Set the color scale
color_scale <- scale_fill_gradient(low = "lightblue", high = "darkblue")

# Plot the multinomial model with colored bars and error bars
ggplot(frequency_data, aes(x = Activity, y = Median, fill = Median)) +
  geom_bar(stat = "identity", position = "dodge") +
  geom_errorbar(aes(ymin = Median - IQR, ymax = Median + IQR),
                width = 0.2, position = position_dodge(0.9)) +
  labs(x = "Activity", y = "Probability of importance level") +
  theme_minimal() +
  color_scale +
  facet_grid(. ~ Group, scales = "free") +
  #  guides(fill = guide_colorbar(title = "Median"))
  guides(fill = guide_colorbar(title = ""))




# Otra forma de hacer el gráfico
#library(ggplot2)
#library(plyr)
#
## Datos del grupo 1
#Median1 <- c(0.998, 1, 1, 1, 0.995)
#IQR1 <- c(0.0399, 0.00614, 0.0918, 0.00682, 0.0653)
#group1 <- rep("<18.77", length(Median1))
#
## Datos del grupo 2
#Median2 <- c(0.902, 0.987, 1, 0.998, 0.89)
#IQR2 <- c(0.249, 0.098, 0.0059, 0.0359, 0.258)
#group2 <- rep(">18.77 & <53.74", length(Median2))
#
## Datos del grupo 3
#Median3 <- c(1, 0.929, 1, 1, 1)
#IQR3 <- c(0.0048, 0.219, 0.00767, 0.00364, 0.00475)
#group3 <- rep(">53.74", length(Median3))
#
## Combinar todos los datos en un data frame
#frequency_data <- data.frame(Activity = rep(c("A1", "A2", "A3", "A4", "A5"), 3),
#                             Median = c(Median1, Median2, Median3),
#                             IQR = c(IQR1, IQR2, IQR3),
#                             Group = c(group1, group2, group3))
#
## Set the color scale
##color_scale <- scale_fill_gradient(name = "Scale", low = "lightblue", high = "darkblue")
#color_scale <- scale_fill_manual(values = c("<18.77" = "lightblue", ">18.77 & <53.74" = "lightgreen", ">53.74" = "lavender"))
#
## Plot the multinomial model with colored bars and error bars
#ggplot(frequency_data, aes(x = Activity, y = Median, fill = Group)) +
#  geom_bar(stat = "identity", position = "dodge") +
#  geom_errorbar(aes(ymin = Median - IQR, ymax = Median + IQR),
#                width = 0.2, position = position_dodge(0.9)) +
#  labs(x = "Activity", y = "Probability of importance level") +
#  theme_minimal() +
#  color_scale +
#  guides(fill = guide_legend(title = "Group"))
