# se importa la base de datos "data.xlsx"

summary(data)  # resumen estadístico de los datos
attach(data)   # para llamar las variables por su nombre

#############################################################################################
#############################################################################################
#############################################################################################
# C?lculo de ?ndices de Hill
install.packages("iNEXT")

install.packages('devtools')
library(devtools)
install_github('JohnsonHsieh/iNEXT')

library(iNEXT)
library(ggplot2)

library(dplyr)

##################################################
#### cálculo de índice de diversidad de Hill para las Especies por Fragmento
dd=data %>%                         
    group_by(Fragmento) %>% 
    count(Especie)

Fragmento_1=sort(filter(dd,Fragmento == 'F1')$n,decreasing = T);Fragmento_2=sort(filter(dd,Fragmento == 'F2')$n,decreasing = T)
Fragmento_3=sort(filter(dd,Fragmento == 'F3')$n,decreasing = T);Fragmento_4=sort(filter(dd,Fragmento == 'F4')$n,decreasing = T)
Fragmento_5=sort(filter(dd,Fragmento == 'F5')$n,decreasing = T)

frag=list(Fragmento_1=Fragmento_1,Fragmento_2=Fragmento_2,Fragmento_3=Fragmento_3,
          Fragmento_4=Fragmento_4,Fragmento_5=Fragmento_5)


out = iNEXT(frag, q=c(0, 1, 2), datatype="abundance", endpoint=200,nboot=1000)
out
# Sample-size-based R/E curves, separating by "site""
#levels(out$iNextEst$size_based$Method) <- list("Rarefaction" = "Rareza","Observed"="Observado","Extrapolation" = "Extrapolación")

ifelse(out$iNextEst$size_based$Method=='Rarefaction','Rareza',ifelse(out$iNextEst$size_based$Method=='Extrapolation','Extrapolación','Observado'))

g=ggiNEXT(out, type=1, facet.var="Assemblage",color.var="Order.q")

g + labs(x = "Número de individuos", y = "Diversidad de especies") + theme(axis.title.y = element_text(size = rel(0.8)),
                                                                           axis.title.x = element_text(size = rel(0.8)),
                                                                           axis.text.x = element_text(size=8),
                                                                           axis.text.y = element_text(size=8),
                                                                           legend.text = element_text(size=9),
                                                                           strip.text.x = element_text(size = 9)) + 
  geom_point(size = 0.05,stroke=0.05) 
  
### Sample-size-based R/E curves, separating by "order"
##ggiNEXT(out, type=1, facet.var="order",color.var="both")


##################################################
#### cálculo de índice de diversidad de Hill para las Especies por Puntos de muestreo
dd=data %>%                         
  group_by(Punto) %>% 
  count(Especie)

p1=sort(filter(dd,Punto == 'P1')$n,decreasing = T);p2=sort(filter(dd,Punto == 'P2')$n,decreasing = T)
p3=sort(filter(dd,Punto == 'P3')$n,decreasing = T)

frag=list(p1=p1,p2=p2,p3=p3)


out = iNEXT(frag, q=c(0, 1, 2), datatype="abundance", endpoint=300,nboot=1000)
out
# Sample-size-based R/E curves, separating by "site""
ggiNEXT(out, type=1, facet.var="site",color.var="order")

# Sample-size-based R/E curves, separating by "order"
ggiNEXT(out, type=1, facet.var="order",color.var="both")


##################################################
#### c?lculo de ?ndice de diversidad de Hill para las Especies por Jornada
dd=data %>%                         
  group_by(Jornada) %>% 
  count(Especie)

AM=sort(filter(dd,Jornada == 'am')$n,decreasing = T)
PM=sort(filter(dd,Jornada == 'pm')$n,decreasing = T)


frag=list(AM=AM,PM=PM)


out = iNEXT(frag, q=c(0, 1, 2), datatype="abundance", endpoint=350,nboot=1000)
out
# Sample-size-based R/E curves, separating by "site""
ggiNEXT(out, type=1, facet.var="site",color.var="order")

# Sample-size-based R/E curves, separating by "order"
ggiNEXT(out, type=1, facet.var="order",color.var="both")


##################################################
#### c?lculo de ?ndice de diversidad de Hill para las Especies por Puntos 
# de muestreo, discriminando por Fragmento
dd=data %>%                         
  group_by(Fragmento,Punto) %>% 
  count(Especie)

f1p1=sort(filter(dd,Fragmento=='F1' & Punto == 'P1')$n,decreasing = T);
f1p2=sort(filter(dd,Fragmento=='F1' & Punto == 'P2')$n,decreasing = T);
f1p3=sort(filter(dd,Fragmento=='F1' & Punto == 'P3')$n,decreasing = T);
f2p1=sort(filter(dd,Fragmento=='F2' & Punto == 'P1')$n,decreasing = T);
f2p2=sort(filter(dd,Fragmento=='F2' & Punto == 'P2')$n,decreasing = T);
f2p3=sort(filter(dd,Fragmento=='F2' & Punto == 'P3')$n,decreasing = T);
f3p1=sort(filter(dd,Fragmento=='F3' & Punto == 'P1')$n,decreasing = T);
f3p2=sort(filter(dd,Fragmento=='F3' & Punto == 'P2')$n,decreasing = T);
f3p3=sort(filter(dd,Fragmento=='F3' & Punto == 'P3')$n,decreasing = T);
f4p1=sort(filter(dd,Fragmento=='F4' & Punto == 'P1')$n,decreasing = T);
f4p2=sort(filter(dd,Fragmento=='F4' & Punto == 'P2')$n,decreasing = T);
f4p3=sort(filter(dd,Fragmento=='F4' & Punto == 'P3')$n,decreasing = T);
f5p1=sort(filter(dd,Fragmento=='F5' & Punto == 'P1')$n,decreasing = T);
f5p2=sort(filter(dd,Fragmento=='F5' & Punto == 'P2')$n,decreasing = T);
f5p3=sort(filter(dd,Fragmento=='F5' & Punto == 'P3')$n,decreasing = T);

frag=list(f1p1=f1p1,f1p2=f1p2,f1p3=f1p3,
          f2p1=f2p1,f2p2=f2p2,f2p3=f2p3,
          f3p1=f3p1,f3p2=f3p2,f3p3=f3p3,
          f4p1=f4p1,f4p2=f4p2,f4p3=f4p3,
          f5p1=f5p1,f5p2=f5p2,f5p3=f5p3)


out = iNEXT(frag, q=c(0, 1, 2), datatype="abundance", endpoint=80,nboot=1000)
out
# Sample-size-based R/E curves, separating by "site""
ggiNEXT(out, type=1, facet.var="site",color.var="order")

# Sample-size-based R/E curves, separating by "order"
ggiNEXT(out, type=1, facet.var="order",color.var="both")


##################################################
#### c?lculo de ?ndice de diversidad de Hill para las Especies por Jornada
# discriminando por Fragmento
dd=data %>%                         
  group_by(Jornada) %>% 
  count(Especie)

AM=sort(filter(dd,Jornada == 'am')$n,decreasing = T)
PM=sort(filter(dd,Jornada == 'pm')$n,decreasing = T)


frag=list(AM=AM,PM=PM)


out = iNEXT(frag, q=c(0, 1, 2), datatype="abundance", endpoint=350,nboot=1000)
out
# Sample-size-based R/E curves, separating by "site""
ggiNEXT(out, type=1, facet.var="site",color.var="order")

# Sample-size-based R/E curves, separating by "order"
ggiNEXT(out, type=1, facet.var="order",color.var="both")


#####################################################
#####################################################
#### Algunos test y gr?ficos

wilcox.test(H1.ob[Jornada=="am"],H1.ob[Jornada=="pm"])
wilcox.test(H2.ob[Jornada=="am"],H2.ob[Jornada=="pm"])
wilcox.test(H1.es[Jornada=="am"],H1.es[Jornada=="pm"])
wilcox.test(H2.es[Jornada=="am"],H2.es[Jornada=="pm"])

library(ggplot2)
library(ggpubr)

par(mfrow=c(2,2))
my_comparisons <- list( c("am", "pm") )
ggviolin(data, x = "Jornada", y = "H1.ob", fill = "Jornada",
         palette = c("#00AFBB", "#E7B800"),
         add = "boxplot", add.params = list(fill = "white"))+
  stat_compare_means(comparisons = my_comparisons, label = "p.signif")+ # Add significance levels
  stat_compare_means(label.y = 50)

ggviolin(data, x = "Jornada", y = "H2.ob", fill = "Jornada",
         palette = c("#00AFBB", "#E7B800"),
         add = "boxplot", add.params = list(fill = "white"))+
  stat_compare_means(comparisons = my_comparisons, label = "p.signif")+ # Add significance levels
  stat_compare_means(label.y = 50)

ggviolin(data, x = "Jornada", y = "H1.es", fill = "Jornada",
         palette = c("#00AFBB", "#E7B800"),
         add = "boxplot", add.params = list(fill = "white"))+
  stat_compare_means(comparisons = my_comparisons, label = "p.signif")+ # Add significance levels
  stat_compare_means(label.y = 50)

ggviolin(data, x = "Jornada", y = "H2.es", fill = "Jornada",
         palette = c("#00AFBB", "#E7B800"),
         add = "boxplot", add.params = list(fill = "white"))+
  stat_compare_means(comparisons = my_comparisons, label = "p.signif")+ # Add significance levels
  stat_compare_means(label.y = 50)



#################################3

my_comparisons <- list( c("P1", "P2", "P3") )
ggviolin(data, x = "Punto", y = "H1.ob", fill = "Punto",
         palette = c("#00AFBB", "#E7B800", "#FC4E07"),
         add = "boxplot", add.params = list(fill = "white"))+
  stat_compare_means(comparisons = my_comparisons, label = "p.signif")+ # Add significance levels
  stat_compare_means(label.y = 50)

ggviolin(data, x = "Punto", y = "H2.ob", fill = "Punto",
         palette = c("#00AFBB", "#E7B800", "#FC4E07"),
         add = "boxplot", add.params = list(fill = "white"))+
  stat_compare_means(comparisons = my_comparisons, label = "p.signif")+ # Add significance levels
  stat_compare_means(label.y = 50)

ggviolin(data, x = "Punto", y = "H1.es", fill = "Punto",
         palette = c("#00AFBB", "#E7B800", "#FC4E07"),
         add = "boxplot", add.params = list(fill = "white"))+
  stat_compare_means(comparisons = my_comparisons, label = "p.signif")+ # Add significance levels
  stat_compare_means(label.y = 50)

ggviolin(data, x = "Punto", y = "H2.es", fill = "Punto",
         palette = c("#00AFBB", "#E7B800", "#FC4E07"),
         add = "boxplot", add.params = list(fill = "white"))+
  stat_compare_means(comparisons = my_comparisons, label = "p.signif")+ # Add significance levels
  stat_compare_means(label.y = 50)